﻿Imports System.Windows.Media.Imaging
Imports Microsoft.Xna.Framework.Media

Partial Public Class MainPage
    Inherits PhoneApplicationPage
    Private mediaLib As New MediaLibrary()
    Private rand As New Random()


    Public Sub New()
        InitializeComponent()
        GetRandomPicture()
    End Sub


    Protected Overrides Sub OnManipulationStarted(ByVal args As ManipulationStartedEventArgs)
        GetRandomPicture()

        args.Complete()
        MyBase.OnManipulationStarted(args)
    End Sub


    Private Sub GetRandomPicture()
        Dim pictures = mediaLib.Pictures

        If pictures.Count > 0 Then
            Dim index = rand.Next(pictures.Count)
            Dim pic = pictures(index)

            Dim bmp As New BitmapImage()
            bmp.SetSource(pic.GetImage())
            img.Source = bmp

            txtblk.Text = String.Format("{0}" & System.Environment.NewLine &
                                        "{1}" & System.Environment.NewLine &
                                        "{2}", pic.Name, pic.Album.Name, pic.Date)
        End If
    End Sub
End Class
